import java.io.*;
import java.net.*;
import javax.net.ssl.*;
import java.security.cert.*;
import sun.misc.*;

public class FaxageDemo implements X509TrustManager
{
   public void checkClientTrusted( X509Certificate[] chain, String authType )
   {
   }

   public void checkServerTrusted( X509Certificate[] chain, String authType )
   {
   }

   public X509Certificate[] getAcceptedIssuers()
   {
      return null;
   }

   public static void main( String[] args )
   {
      try
      {
         // Get the file to send
         InputStream templateIn = new FileInputStream( TEMPLATE_FILE );

         // Convert the file to a byte[]
         int fileSize = templateIn.available();
         byte[] FAX_DATA = new byte[fileSize ];
         templateIn.read( FAX_DATA );
	 sun.misc.BASE64Encoder coder = new sun.misc.BASE64Encoder();
	 String FAX_B64_DATA = coder.encode(FAX_DATA);
         templateIn.close();

         /**
          *
          * Use information for the actual user who submitted the form.  If we don't provide this, the header of the fax
          * will include default information registered for the Faxage account
          *
          */
         String SENDER_NAME = "Testing 123"; // Appears in the header of each fax page
         String SENDER_PHONE = "1.303.555.1212"; // Appears in the header of each fax page; 14 characters max

         // Create an SSL connection
         URL url = new URL( FAXAGE_URL );

         SSLContext sslContext = SSLContext.getInstance( "SSLv3" );
         TrustManager[] trustManager = { new FaxageDemo() };
         sslContext.init( null, trustManager, null );
         SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

         HttpsURLConnection.setDefaultSSLSocketFactory( sslSocketFactory );
         HttpsURLConnection connection = ( HttpsURLConnection )url.openConnection();

         connection.setDoOutput( true );
         connection.setDoInput( true );
         connection.setRequestMethod( "POST" );
         connection.setUseCaches( false );
         connection.setRequestProperty( "Content-type", "application/x-www-form-urlencoded" );
         connection.connect();

         // Send the encoded message
         DataOutputStream out = new DataOutputStream( connection.getOutputStream() );

         // Encode the HOST
         out.writeBytes( "host=" );
         out.writeBytes( HOST );

         // Encode the USER_NAME
         out.writeBytes( "&username=" );
         out.writeBytes( USER_NAME );

         // Encode the COMPANY
         out.writeBytes( "&company=" );
         out.writeBytes( COMPANY );

         // Encode the PASSWORD
         out.writeBytes( "&password=" );
         out.writeBytes( PASSWORD );

         // Encode the FAX_NUMBER
         out.writeBytes( "&faxno=" );
         out.writeBytes( FAX_NUMBER );

         // Encode the OPERATION
         out.writeBytes( "&operation=" );
         out.writeBytes( OPERATION );

         // Encode the RECIPIENT_NAME
         out.writeBytes( "&recipname=" );
         out.writeBytes( RECIPIENT_NAME );

         // Encode the FILE_NAME
         out.writeBytes( "&faxfilenames[]=" );
         out.writeBytes( FAX_NAME );

         // Encode the FAX_DATA
         out.writeBytes( "&faxfiledata[]=" );
         out.writeBytes( FAX_B64_DATA ); // base64-encoded contents of the file to be faxed.

         // Encode the SENDER_NAME
         out.writeBytes( "&tagname=" );
         out.writeBytes( SENDER_NAME );

         // Encode the SENDER_PHONE
         out.writeBytes( "&tagnumber=" );
         out.writeBytes( SENDER_PHONE );

         out.flush();
         out.close();

         System.out.println( "Response..." );

         // Get the response
         BufferedReader in = new BufferedReader( new InputStreamReader( connection.getInputStream() ) );
         String line;

         while( ( line = in.readLine() ) != null )
         {
            System.out.print( "           " );
            System.out.println( line );
         }

         in.close();
      }

      catch( Exception e )
      {
         e.printStackTrace();
      }

      System.exit( 0 );
   }

   private static final String FAX_NAME = "test.pdf"; // MUST end with a case non-sensitive, supported file extension (e.g. "pdf")
   private static final File TEMPLATE_FILE = new File( FAX_NAME );
   private static final String HOST = "api.faxage.com";

   private static final String FAXAGE_URL = "https://" + HOST + "/httpsfax.php";

   private static final String USER_NAME = "XXXXXX";
   private static final String COMPANY = "XXXXXX";
   private static final String PASSWORD = "XXXXXX";
   private static final String RECIPIENT_NAME = "test";
   private static final String FAX_NUMBER = "";
   private static final String OPERATION = "sendfax";
}
