#!/usr/bin/perl
#
# status-example.pl
#
# Example https client for
# posting a status request
# to the FAXAGE Web API
#
# Revision History:
# 2006-02-28 - Original Writing - CMW
#
# 2017-09-14 - Updated for new API
# endpoint api.faxage.com - CMW
#
# See also sendfax-example.pl and
# clear-example.pl for other relevant
# operations
#
# Copyright 2006 EC Data Systems, Inc.
# Unauthorized use or disclosure is
# strictly prohibited
#######################################

use HTTP::Request::Common qw(POST GET); 
use HTTP::Headers; 
use LWP::UserAgent; 
use LWP::Protocol::https; 
use URI::https; 

# POST info 
$username = "XXXXXXX"; 
$company = "XXXXXXX"; 
$password = "XXXXXXX"; 
$operation = "status";
$jobid = $ARGV[0]; 
# If jobid is specified, gets
# status for only that job,
# otherwise gets status for
# all jobs

# User agent
my $ua = LWP::UserAgent->new();
$ua->agent("FAXAGETest/v1.0 UNIX");

my $faxserver = "api.faxage.com"; 
my $url = "https://" . $faxserver . "/httpsfax.php";

my $req = POST(
$url,
Content_Type => 'form-data',
Content => [
"host" => "$faxserver",
"username" => "$username",
"company" => "$company",
"password" => "$password",
"operation" => "$operation",
"jobid" => "$jobid"
],
);

my $res = $ua->request($req); 

my $err = $res->status_line; 

$_ = $res->as_string;

if(/Illegal Operation/ig || $err != 200) {
print "Error: $err\n";
exit 1;
}

# Would need to actually parse the 
# output here and store the data
# someplace or deal with error
# responses
print "$_";
exit 0;
