#!/usr/bin/perl
#
# Example https client for
# posting a getfax request
# to the FAXAGE Web API
#
# Revision History:
# 2006-02-28 - Original Writing - CMW
#
# 2017-09-14 - Updated for new API
# endpoint api.faxage.com - CMW
#
# Copyright 2006 EC Data Systems, Inc.
# Unauthorized use or disclosure is
# strictly prohibited
#######################################

use HTTP::Request::Common qw(POST GET); 
use HTTP::Headers; 
use LWP::UserAgent; 
use LWP::Protocol::https; 
use URI::https; 
use MIME::Base64;

# POST info 
$username = "XXXXXXX"; 
$company = "XXXXXXX"; 
$password = "XXXXXXX"; 
$operation = "getfax";
$faxid = $ARGV[0];
# Will get the specified
# received fax id from the
# system (application/octet-stream
# attachment back to the browser)

# User agent
my $ua = LWP::UserAgent->new();
$ua->agent("FAXAGETest/v1.0 UNIX");

my $faxserver = "api.faxage.com"; 
my $url = "https://" . $faxserver . "/httpsfax.php";

my $req = POST(
$url, 
Content_Type => 'form-data', 
Content => [ 
"host" => "$faxserver",
"username" => "$username",
"company" => "$company",
"password" => "$password",
"operation" => "$operation",
"faxid" => "$faxid",
],
);

my $res = $ua->request($req); 

my $err = $res->status_line; 

$_ = $res->as_string;

if(/Illegal Operation/ig || $err != 200) { 
print "Error: $err\n"; 
exit 1; 
} 

# Would need to actually parse the 
# output here and store the job id
# someplace or deal with error
# responses
print "$_";
exit 0;
