#!/usr/bin/perl
#
# Example https client for
# posting a sendfax request
# to the FAXAGE Web API, specifying
# a URL rather than uploading file
# data
#
# Revision History:
# 2006-07-06 - Original Writing - CMW
#
# 2017-09-14 - Updated for new API
# endpoint api.faxage.com - CMW
#
# Copyright 2006 EC Data Systems, Inc.
# Unauthorized use or disclosure is
# strictly prohibited
#######################################

use HTTP::Request::Common qw(POST GET); 
use HTTP::Headers; 
use LWP::UserAgent; 
use LWP::Protocol::https; 
use URI::https; 
use MIME::Base64;

# POST info 
$username = "XXXXXXX"; 
$company = "XXXXXXX"; 
$password = "XXXXXXX"; 
$recipname = "Testing 123";
$faxno = "3035551212"; 
$operation = "sendfax";
$tagname = "Testme 123";
$tagnumber = "1.303.555.1212";

# URL to fax out
$faxurl = "http://www.mywebsite.com/mywebpage.htm";
 
# User agent
my $ua = LWP::UserAgent->new();
$ua->agent("FAXAGETest/v1.0 UNIX");

my $faxserver = "api.faxage.com"; 
my $url = "https://" . $faxserver . "/httpsfax.php";

my $req = POST( 
$url, 
Content_Type => 'form-data', 
Content => [ 
"host" => "$faxserver",
"username" => "$username",
"company" => "$company",
"password" => "$password",
"faxno" => "$faxno",
"operation" => "$operation",
"recipname" => "$recipname",
"faxurl" => "$faxurl",
"tagname" => "$tagname",
"tagnumber" => "$tagnumber"
],
);

my $res = $ua->request($req); 

my $err = $res->status_line; 

$_ = $res->as_string;

if(/Illegal Operation/ig || $err != 200) { 
print "Error: $err\n"; 
exit 1; 
} 

# Would need to actually parse the 
# output here and store the job id
# someplace or deal with error 
# responses 
print "$_";
exit 0;
